/* OOQP                                                               *
* Authors: E. Michael Gertz, Stephen J. Wright                       *
* (C) 2001 University of Chicago. See Copyright Notification in OOQP */

/* PARDISO Solver Implemented by J.Currie September 2011 */

#ifndef PARDISOLINSYS_H
#define PARDISOLINSYS_H

#include "DoubleLinearSolver.h"
#include "SparseSymMatrixHandle.h"
#include "SparseStorageHandle.h"
#include "OoqpVectorHandle.h"
#include "SimpleVector.h"

#include "mkl_types.h"
#include "mkl_pardiso.h"

// implements the linear solver class using the Pardiso solver

class PardisoSolver : public DoubleLinearSolver {
protected:
	//Pardiso Control Parameters
	MKL_INT   iparm[64];
	MKL_INT	  maxfct, nrhs, mnum, phase, error, msglvl, mtype;

	//Pardiso Internal Memory
	void *pt[64];

	//Dummy vars
	MKL_INT idum;
	double ddum;

	//System Matrix
	SparseSymMatrixHandle mMat;
	int n; //number dec vars
	double *a;
	MKL_INT *ia, *ja;
	//Local Work Memory for Transpose
	int *lmem, *inc;
	//Diagonal
	SimpleVector *diagVec;
	int *diagInd;

	//Internal Vars
	int is_init;
	double *x;

	//First Call to Setup Internal Solver Memory
	virtual void firstCall();
	//Update Sparse Vectors (Transpose)
	virtual void updateSparseVec();

public:
	//Constructor
	PardisoSolver( SparseSymMatrix * ssm );
	//Destructor
	virtual ~PardisoSolver();

	//Matrix Changed Methods
	virtual void diagonalChanged( int idiag, int extent );
	virtual void matrixChanged();

	//Solve System
	virtual void solve( OoqpVector& rhs );
};

#endif



